/*
 * Copyright (C) 2014-2016 Altera Corporation <www.altera.com>
 *
 * SPDX-License-Identifier:	GPL-2.0
 */

#ifndef	_ARRIA10_SYSTEM_MANAGER_H_
#define	_ARRIA10_SYSTEM_MANAGER_H_

#include <mach/socfpga/arria10-regs.h>

#define ARRIA10_SYSMGR_SILICONID1		(ARRIA10_SYSMGR_ADDR + 0x00)
#define ARRIA10_SYSMGR_SILICONID2		(ARRIA10_SYSMGR_ADDR + 0x04)
#define ARRIA10_SYSMGR_WDDBG			(ARRIA10_SYSMGR_ADDR + 0x08)
#define ARRIA10_SYSMGR_BOOTINFO			(ARRIA10_SYSMGR_ADDR + 0x0c)
#define ARRIA10_SYSMGR_MPU_CTRL_L2_ECC		(ARRIA10_SYSMGR_ADDR + 0x10)
#define ARRIA10_SYSMGR_DMA			(ARRIA10_SYSMGR_ADDR + 0x20)
#define ARRIA10_SYSMGR_DMA_PERIPH		(ARRIA10_SYSMGR_ADDR + 0x24)
#define ARRIA10_SYSMGR_SDMMC			(ARRIA10_SYSMGR_ADDR + 0x28)
#define ARRIA10_SYSMGR_SDMMC_L3MASTER		(ARRIA10_SYSMGR_ADDR + 0x2c)
#define ARRIA10_SYSMGR_NAND_BOOTSTRAP		(ARRIA10_SYSMGR_ADDR + 0x30)
#define ARRIA10_SYSMGR_NAND_L3MASTER		(ARRIA10_SYSMGR_ADDR + 0x34)
#define ARRIA10_SYSMGR_USB0_L3MASTER		(ARRIA10_SYSMGR_ADDR + 0x38)
#define ARRIA10_SYSMGR_USB1_L3MASTER		(ARRIA10_SYSMGR_ADDR + 0x3c)
#define ARRIA10_SYSMGR_EMAC_GLOBAL		(ARRIA10_SYSMGR_ADDR + 0x40)
#define ARRIA10_SYSMGR_EMAC0			(ARRIA10_SYSMGR_ADDR + 0x44)
#define ARRIA10_SYSMGR_EMAC1			(ARRIA10_SYSMGR_ADDR + 0x48)
#define ARRIA10_SYSMGR_EMAC2			(ARRIA10_SYSMGR_ADDR + 0x4c)
#define ARRIA10_SYSMGR_FPGAINTF_GLOBAL		(ARRIA10_SYSMGR_ADDR + 0x60)
#define ARRIA10_SYSMGR_FPGAINTF_EN_0		(ARRIA10_SYSMGR_ADDR + 0x64)
#define ARRIA10_SYSMGR_FPGAINTF_EN_1		(ARRIA10_SYSMGR_ADDR + 0x68)
#define ARRIA10_SYSMGR_FPGAINTF_EN_2		(ARRIA10_SYSMGR_ADDR + 0x6c)
#define ARRIA10_SYSMGR_FPGAINTF_EN_3		(ARRIA10_SYSMGR_ADDR + 0x70)
#define ARRIA10_SYSMGR_NOC_ADDR_REMAP_VALUE 	(ARRIA10_SYSMGR_ADDR + 0x80)
#define ARRIA10_SYSMGR_NOC_ADDR_REMAP_SET 	(ARRIA10_SYSMGR_ADDR + 0x84)
#define ARRIA10_SYSMGR_NOC_ADDR_REMAP_CLEAR 	(ARRIA10_SYSMGR_ADDR + 0x88)
#define ARRIA10_SYSMGR_ECC_INTMASK_VALUE 	(ARRIA10_SYSMGR_ADDR + 0x90)
#define ARRIA10_SYSMGR_ECC_INTMASK_SET 		(ARRIA10_SYSMGR_ADDR + 0x94)
#define ARRIA10_SYSMGR_ECC_INTMASK_CLR 		(ARRIA10_SYSMGR_ADDR + 0x98)
#define ARRIA10_SYSMGR_ECC_INTSTATUS_SERR 	(ARRIA10_SYSMGR_ADDR + 0x9c)
#define ARRIA10_SYSMGR_ECC_INTSTATUS_DERR 	(ARRIA10_SYSMGR_ADDR + 0xa0)
#define ARRIA10_SYSMGR_MPU_STATUS_L2_ECC 	(ARRIA10_SYSMGR_ADDR + 0xa4)
#define ARRIA10_SYSMGR_MPU_CLEAR_L2_ECC 	(ARRIA10_SYSMGR_ADDR + 0xa8)
#define ARRIA10_SYSMGR_MPU_STATUS_L1_PARITY 	(ARRIA10_SYSMGR_ADDR + 0xac)
#define ARRIA10_SYSMGR_MPU_CLEAR_L1_PARITY 	(ARRIA10_SYSMGR_ADDR + 0xb0)
#define ARRIA10_SYSMGR_MPU_SET_L1_PARITY 	(ARRIA10_SYSMGR_ADDR + 0xb4)
#define ARRIA10_SYSMGR_NOC_TIMEOUT 		(ARRIA10_SYSMGR_ADDR + 0xc0)
#define ARRIA10_SYSMGR_NOC_IDLEREQ_SET		(ARRIA10_SYSMGR_ADDR + 0xc4)
#define ARRIA10_SYSMGR_NOC_IDLEREQ_CLR		(ARRIA10_SYSMGR_ADDR + 0xc8)
#define ARRIA10_SYSMGR_NOC_IDLEREQ_VALUE	(ARRIA10_SYSMGR_ADDR + 0xcc)
#define ARRIA10_SYSMGR_NOC_IDLEACK		(ARRIA10_SYSMGR_ADDR + 0xd0)
#define ARRIA10_SYSMGR_NOC_IDLESTATUS		(ARRIA10_SYSMGR_ADDR + 0xd4)
#define ARRIA10_SYSMGR_FPGA2SOC_CTRL		(ARRIA10_SYSMGR_ADDR + 0xd8)

#define ARRIA10_SYSMGR_ROM_INITSWLASTLD		(ARRIA10_SYSMGR_ADDR + 0x10)


#define ARRIA10_SYSMGR_BOOTINFO_BSEL_MASK	0x00007000
#define ARRIA10_SYSMGR_BOOTINFO_BSEL_SHIFT	12

/* pin mux */
#define ARRIA10_SYSMGR_PINMUXGRP		(ARRIA10_SYSMGR_ADDR + 0x400)
#define ARRIA10_SYSMGR_PINMUXGRP_NANDUSEFPGA	(ARRIA10_SYSMGR_PINMUXGRP + 0x2F0)
#define ARRIA10_SYSMGR_PINMUXGRP_EMAC1USEFPGA	(ARRIA10_SYSMGR_PINMUXGRP + 0x2F8)
#define ARRIA10_SYSMGR_PINMUXGRP_SDMMCUSEFPGA	(ARRIA10_SYSMGR_PINMUXGRP + 0x308)
#define ARRIA10_SYSMGR_PINMUXGRP_EMAC0USEFPGA	(ARRIA10_SYSMGR_PINMUXGRP + 0x314)
#define ARRIA10_SYSMGR_PINMUXGRP_SPIM1USEFPGA	(ARRIA10_SYSMGR_PINMUXGRP + 0x330)
#define ARRIA10_SYSMGR_PINMUXGRP_SPIM0USEFPGA	(ARRIA10_SYSMGR_PINMUXGRP + 0x338)

/* bit fields */
#define ARRIA10_SYSMGR_ROMCODEGRP_CTRL_WARMRSTCFGPINMUX		BIT(0)
#define ARRIA10_SYSMGR_ROMCODEGRP_CTRL_WARMRSTCFGIO		BIT(1)
#define ARRIA10_SYSMGR_ECC_OCRAM_EN				BIT(0)
#define ARRIA10_SYSMGR_ECC_OCRAM_SERR				BIT(3)
#define ARRIA10_SYSMGR_ECC_OCRAM_DERR				BIT(4)
#define ARRIA10_SYSMGR_FPGAINTF_USEFPGA				BIT(1)
#define ARRIA10_SYSMGR_FPGAINTF_SPIM0				BIT(0)
#define ARRIA10_SYSMGR_FPGAINTF_SPIM1				BIT(1)
#define ARRIA10_SYSMGR_FPGAINTF_EMAC0				BIT(2)
#define ARRIA10_SYSMGR_FPGAINTF_EMAC1				BIT(3)
#define ARRIA10_SYSMGR_FPGAINTF_NAND				BIT(4)
#define ARRIA10_SYSMGR_FPGAINTF_SDMMC				BIT(5)

#define ARRIA10_SYSMGR_EMACGRP_CTRL_PHYSEL_ENUM_GMII_MII	0x0
#define ARRIA10_SYSMGR_EMACGRP_CTRL_PHYSEL_ENUM_RGMII		0x1
#define ARRIA10_SYSMGR_EMACGRP_CTRL_PHYSEL_ENUM_RMII		0x2
#define ARRIA10_SYSMGR_EMACGRP_CTRL_PHYSEL_LSB			0
#define ARRIA10_SYSMGR_EMACGRP_CTRL_PHYSEL_MASK			0x00000003

#define ARRIA10_SYSMGR_FPGAINTF_EN3_EMAC0	BIT(0)
#define ARRIA10_SYSMGR_FPGAINTF_EN3_EMAC0_SW	BIT(4)
#define ARRIA10_SYSMGR_FPGAINTF_EN3_EMAC1	BIT(8)
#define ARRIA10_SYSMGR_FPGAINTF_EN3_EMAC1_SW	BIT(12)
#define ARRIA10_SYSMGR_FPGAINTF_EN3_EMAC2	BIT(16)
#define ARRIA10_SYSMGR_FPGAINTF_EN3_EMAC2_SW	BIT(20)

#define ARRIA10_SYSMGR_SDMMC_SMPLSEL(smplsel)	(((smplsel) & 0x7) << 4)
#define ARRIA10_SYSMGR_SDMMC_DRVSEL(drvsel)	((drvsel) & 0x7)

#define SYSMGR_SDMMC_CTRL_SET(smplsel, drvsel)	\
	((drvsel << 0) & 0x7) | ((smplsel << 4) & 0x70)

#endif
