#ifndef __MACH_IMX50_REGS_H
#define __MACH_IMX50_REGS_H

#include <linux/sizes.h>

#define MX50_IROM_BASE_ADDR	0x0

#define MX50_IRAM_BASE_ADDR     0xF8000000
#define MX50_IRAM_SIZE          SZ_128K

/*
 * SPBA global module enabled #0
 */
#define MX50_SPBA0_BASE_ADDR		0x50000000
#define MX50_SPBA0_SIZE		SZ_1M

#define MX50_ESDHC1_BASE_ADDR	(MX50_SPBA0_BASE_ADDR + 0x00004000)
#define MX50_ESDHC2_BASE_ADDR	(MX50_SPBA0_BASE_ADDR + 0x00008000)
#define MX50_UART3_BASE_ADDR		(MX50_SPBA0_BASE_ADDR + 0x0000C000)
#define MX50_ECSPI1_BASE_ADDR		(MX50_SPBA0_BASE_ADDR + 0x00010000)
#define MX50_SSI2_BASE_ADDR		(MX50_SPBA0_BASE_ADDR + 0x00014000)
#define MX50_ESDHC3_BASE_ADDR	(MX50_SPBA0_BASE_ADDR + 0x00020000)
#define MX50_ESDHC4_BASE_ADDR	(MX50_SPBA0_BASE_ADDR + 0x00024000)
#define MX50_SPBA_CTRL_BASE_ADDR	(MX50_SPBA0_BASE_ADDR + 0x0003C000)

/*
 * AIPS 1
 */
#define MX50_AIPS1_BASE_ADDR	0x53F00000
#define MX50_AIPS1_SIZE		SZ_512K

#define MX50_OTG_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x00080000)
#define MX50_GPIO1_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x00084000)
#define MX50_GPIO2_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x00088000)
#define MX50_GPIO3_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x0008C000)
#define MX50_GPIO4_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x00090000)
#define MX50_KPP_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x00094000)
#define MX50_WDOG1_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x00098000)
#define MX50_GPT1_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000A0000)
#define MX50_SRTC_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000A4000)
#define MX50_IOMUXC_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000A8000)
#define MX50_EPIT1_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000AC000)
#define MX50_PWM1_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000B4000)
#define MX50_PWM2_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000B8000)
#define MX50_UART1_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000BC000)
#define MX50_UART2_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000C0000)

#define MX50_SRC_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000D0000)
#define MX50_CCM_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000D4000)
#define MX50_GPC_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000D8000)
#define MX50_GPIO5_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000DC000)
#define MX50_GPIO6_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000E0000)
#define MX50_I2C3_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000EC000)
#define MX50_UART4_BASE_ADDR	(MX50_AIPS1_BASE_ADDR + 0x000F0000)

/*
 * AIPS 2
 */
#define MX50_AIPS2_BASE_ADDR		0x63F00000
#define MX50_AIPS2_SIZE			SZ_512K

#define MX50_PLL1_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x00080000)
#define MX50_PLL2_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x00084000)
#define MX50_PLL3_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x00088000)
#define MX50_UART5_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x00090000)
#define MX50_AHBMAX_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x00094000)
#define MX50_ARM_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000A0000)
#define MX50_OWIRE_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000A4000)
#define MX50_ECSPI2_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000AC000)
#define MX50_SDMA_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000B0000)
#define MX50_ROMCP_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000B8000)
#define MX50_CSPI_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000C0000)
#define MX50_I2C2_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000C4000)
#define MX50_I2C1_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000C8000)
#define MX50_SSI1_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000CC000)
#define MX50_AUDMUX_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000D0000)
#define MX50_WEIM_BASE_ADDR     (MX50_AIPS2_BASE_ADDR + 0x000DA000)
#define MX50_FEC_BASE_ADDR	(MX50_AIPS2_BASE_ADDR + 0x000EC000)

/*
 * Memory regions and CS
 */
#define MX50_CSD0_BASE_ADDR		0x70000000
#define MX50_CSD1_BASE_ADDR		0xB0000000
#define MX50_CS0_BASE_ADDR		0xF0000000
#define MX50_CS1_32MB_BASE_ADDR		0xF2000000
#define MX50_CS1_64MB_BASE_ADDR		0xF4000000
#define MX50_CS2_64MB_BASE_ADDR		0xF4000000
#define MX50_CS2_96MB_BASE_ADDR		0xF6000000
#define MX50_CS3_BASE_ADDR		0xF6000000

#endif /* __MACH_IMX50_REGS_H */
