/*
 * Copyright (c) 2013, NVIDIA CORPORATION.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * parse_t124.c - The implementation for parsing dev/sdram parameters
 */

#include "../parse.h"
#include "nvboot_bct_t124.h"

enum_item s_devtype_table_t124[] = {
	{ "NvBootDevType_Sdmmc", nvboot_dev_type_sdmmc },
	{ "NvBootDevType_Spi", nvboot_dev_type_spi },
	{ "Sdmmc", nvboot_dev_type_sdmmc },
	{ "Spi", nvboot_dev_type_spi },
	{ NULL, 0 }
};

enum_item s_sdmmc_data_width_table_t124[] = {
	{
	  "NvBootSdmmcDataWidth_4Bit",
	  nvboot_sdmmc_data_width_4bit
	},
	{
	  "NvBootSdmmcDataWidth_8Bit",
	  nvboot_sdmmc_data_width_8bit
	},
	{ "4Bit", nvboot_sdmmc_data_width_4bit },
	{ "8Bit", nvboot_sdmmc_data_width_8bit },
	{ NULL, 0 }
};

enum_item s_spi_clock_source_table_t124[] = {
	{ "NvBootSpiClockSource_PllPOut0", nvboot_spi_clock_source_pllp_out0 },
	{ "NvBootSpiClockSource_ClockM", nvboot_spi_clock_source_clockm },
	{ "ClockSource_PllPOut0", nvboot_spi_clock_source_pllp_out0 },
	{ "ClockSource_ClockM", nvboot_spi_clock_source_clockm },
	{ "PllPOut0", nvboot_spi_clock_source_pllp_out0 },
	{ "ClockM", nvboot_spi_clock_source_clockm },
	{ NULL, 0 }
};

enum_item s_nvboot_memory_type_table_t124[] = {
	{ "NvBootMemoryType_None", nvboot_memory_type_none },
	{ "NvBootMemoryType_Ddr3", nvboot_memory_type_ddr3 },
	{ "NvBootMemoryType_Ddr2", nvboot_memory_type_ddr2 },
	{ "NvBootMemoryType_Ddr", nvboot_memory_type_ddr },
	{ "NvBootMemoryType_LpDdr2", nvboot_memory_type_lpddr2 },
	{ "NvBootMemoryType_LpDdr", nvboot_memory_type_lpddr },

	{ "None", nvboot_memory_type_none },
	{ "Ddr3", nvboot_memory_type_ddr3 },
	{ "Ddr2", nvboot_memory_type_ddr2 },
	{ "Ddr", nvboot_memory_type_ddr },
	{ "LpDdr2", nvboot_memory_type_lpddr2 },
	{ "LpDdr", nvboot_memory_type_lpddr },

	{ NULL, 0 }
};

#define TOKEN(name)						\
	token_##name, field_type_u32, NULL

field_item s_sdram_field_table_t124[] = {
	{ "MemoryType", token_memory_type,
	  field_type_enum, s_nvboot_memory_type_table_t124 },

	{ "PllMInputDivider",           TOKEN(pllm_input_divider) },
	{ "PllMFeedbackDivider",        TOKEN(pllm_feedback_divider) },
	{ "PllMStableTime",             TOKEN(pllm_stable_time) },
	{ "PllMSetupControl",           TOKEN(pllm_setup_control) },
	{ "PllMSelectDiv2",             TOKEN(pllm_select_div2) },
	{ "PllMPDLshiftPh45",           TOKEN(pllm_pdlshift_ph45) },
	{ "PllMPDLshiftPh90",           TOKEN(pllm_pdlshift_ph90) },
	{ "PllMPDLshiftPh135",          TOKEN(pllm_pdlshift_ph135) },
	{ "PllMKCP",                    TOKEN(pllm_kcp) },
	{ "PllMKVCO",                   TOKEN(pllm_kvco) },
	{ "EmcBctSpare0",               TOKEN(emc_bct_spare0) },
	{ "EmcBctSpare1",               TOKEN(emc_bct_spare1) },
	{ "EmcBctSpare2",               TOKEN(emc_bct_spare2) },
	{ "EmcBctSpare3",               TOKEN(emc_bct_spare3) },
	{ "EmcBctSpare4",               TOKEN(emc_bct_spare4) },
	{ "EmcBctSpare5",               TOKEN(emc_bct_spare5) },
	{ "EmcBctSpare6",               TOKEN(emc_bct_spare6) },
	{ "EmcBctSpare7",               TOKEN(emc_bct_spare7) },
	{ "EmcBctSpare8",               TOKEN(emc_bct_spare8) },
	{ "EmcBctSpare9",               TOKEN(emc_bct_spare9) },
	{ "EmcBctSpare10",              TOKEN(emc_bct_spare10) },
	{ "EmcBctSpare11",              TOKEN(emc_bct_spare11) },
	{ "EmcAutoCalInterval",         TOKEN(emc_auto_cal_interval) },
	{ "EmcAutoCalConfig",           TOKEN(emc_auto_cal_config) },
	{ "EmcAutoCalConfig2",          TOKEN(emc_auto_cal_config2) },
	{ "EmcAutoCalConfig3",          TOKEN(emc_auto_cal_config3) },
	{ "EmcAutoCalWait",             TOKEN(emc_auto_cal_wait) },
	{ "EmcPinProgramWait",          TOKEN(emc_pin_program_wait) },
	{ "EmcRc",                      TOKEN(emc_rc) },
	{ "EmcRfc",                     TOKEN(emc_rfc) },
	{ "EmcRfcSlr",                  TOKEN(emc_rfc_slr) },
	{ "EmcRas",                     TOKEN(emc_ras) },
	{ "EmcRp",                      TOKEN(emc_rp) },
	{ "EmcR2r",                     TOKEN(emc_r2r) },
	{ "EmcW2w",                     TOKEN(emc_w2w) },
	{ "EmcR2w",                     TOKEN(emc_r2w) },
	{ "EmcW2r",                     TOKEN(emc_w2r) },
	{ "EmcR2p",                     TOKEN(emc_r2p) },
	{ "EmcW2p",                     TOKEN(emc_w2p) },
	{ "EmcRrd",                     TOKEN(emc_rrd) },
	{ "EmcRdRcd",                   TOKEN(emc_rd_rcd) },
	{ "EmcWrRcd",                   TOKEN(emc_wr_rcd) },
	{ "EmcRext",                    TOKEN(emc_rext) },
	{ "EmcWdv",                     TOKEN(emc_wdv) },
	{ "EmcWdvMask",                 TOKEN(emc_wdv_mask) },
	{ "EmcQUse",                    TOKEN(emc_quse) },
	{ "EmcQuseWidth",               TOKEN(emc_quse_width) },
	{ "EmcIbdly",                   TOKEN(emc_ibdly) },
	{ "EmcEInput",                  TOKEN(emc_einput) },
	{ "EmcEInputDuration",          TOKEN(emc_einput_duration) },
	{ "EmcPutermExtra",             TOKEN(emc_puterm_extra) },
	{ "EmcPutermWidth",             TOKEN(emc_puterm_width) },
	{ "EmcPutermAdj",               TOKEN(emc_puterm_adj) },
	{ "EmcCdbCntl1",                TOKEN(emc_cdb_cntl1) },
	{ "EmcCdbCntl2",                TOKEN(emc_cdb_cntl2) },
	{ "EmcCdbCntl3",                TOKEN(emc_cdb_cntl3) },
	{ "EmcQRst",                    TOKEN(emc_qrst) },
	{ "EmcQSafe",                   TOKEN(emc_qsafe) },
	{ "EmcRdv",                     TOKEN(emc_rdv) },
	{ "EmcRdvMask",                 TOKEN(emc_rdv_mask) },
	{ "EmcQpop",                    TOKEN(emc_qpop) },
	{ "EmcRefresh",                 TOKEN(emc_refresh) },
	{ "EmcBurstRefreshNum",         TOKEN(emc_burst_refresh_num) },
	{ "EmcPdEx2Wr",                 TOKEN(emc_pdex2wr) },
	{ "EmcPdEx2Rd",                 TOKEN(emc_pdex2rd) },
	{ "EmcPChg2Pden",               TOKEN(emc_pchg2pden) },
	{ "EmcAct2Pden",                TOKEN(emc_act2pden) },
	{ "EmcAr2Pden",                 TOKEN(emc_ar2pden) },
	{ "EmcRw2Pden",                 TOKEN(emc_rw2pden) },
	{ "EmcTxsr",                    TOKEN(emc_txsr) },
	{ "EmcTcke",                    TOKEN(emc_tcke) },
	{ "EmcTckesr",                  TOKEN(emc_tckesr) },
	{ "EmcTpd",                     TOKEN(emc_tpd) },
	{ "EmcTfaw",                    TOKEN(emc_tfaw) },
	{ "EmcTrpab",                   TOKEN(emc_trpab) },
	{ "EmcTClkStable",              TOKEN(emc_tclkstable) },
	{ "EmcTClkStop",                TOKEN(emc_tclkstop) },
	{ "EmcTRefBw",                  TOKEN(emc_trefbw) },
	{ "EmcFbioCfg5",                TOKEN(emc_fbio_cfg5) },
	{ "EmcFbioCfg6",                TOKEN(emc_fbio_cfg6) },
	{ "EmcFbioSpare",               TOKEN(emc_fbio_spare) },
	{ "EmcMrsResetDllWait",         TOKEN(emc_mrs_reset_dll_wait) },
	{ "EmcMrsResetDll",             TOKEN(emc_mrs_reset_dll) },
	{ "EmcMrsDdr2DllReset",         TOKEN(emc_mrs_ddr2_dll_reset) },
	{ "EmcMrs",                     TOKEN(emc_mrs) },
	{ "EmcEmrs2",                   TOKEN(emc_emrs2) },
	{ "EmcEmrs3",                   TOKEN(emc_emrs3) },
	{ "EmcEmrsDdr2DllEnable",       TOKEN(emc_emrs_ddr2_dll_enable) },
	{ "EmcEmrsDdr2OcdCalib",        TOKEN(emc_emrs_ddr2_ocd_calib) },
	{ "EmcEmrs",                    TOKEN(emc_emrs) },
	{ "EmcMrw1",                    TOKEN(emc_mrw1) },
	{ "EmcMrw2",                    TOKEN(emc_mrw2) },
	{ "EmcMrw3",                    TOKEN(emc_mrw3) },
	{ "EmcMrw4",                    TOKEN(emc_mrw4) },
	{ "EmcMrwResetCommand",         TOKEN(emc_mrw_reset_command) },
	{ "EmcMrwResetNInitWait",       TOKEN(emc_mrw_reset_ninit_wait) },
	{ "EmcAdrCfg",                  TOKEN(emc_adr_cfg) },
	{ "McEmemCfg",                  TOKEN(mc_emem_cfg) },
	{ "EmcCfg2",                    TOKEN(emc_cfg2) },
	{ "EmcCfgPipe",                 TOKEN(emc_cfg_pipe) },
	{ "EmcCfgDigDll",               TOKEN(emc_cfg_dig_dll) },
	{ "EmcCfgDigDllPeriod",         TOKEN(emc_cfg_dig_dll_period) },
	{ "EmcCfg",                     TOKEN(emc_cfg) },
	{ "EmcDbg",                     TOKEN(emc_dbg) },
	{ "WarmBootWait",               TOKEN(warm_boot_wait) },
	{ "EmcCttTermCtrl",             TOKEN(emc_ctt_term_ctrl) },
	{ "EmcOdtWrite",                TOKEN(emc_odt_write) },
	{ "EmcOdtRead",                 TOKEN(emc_odt_read) },
	{ "EmcZcalWaitCnt",             TOKEN(emc_zcal_wait_cnt) },
	{ "EmcZcalMrwCmd",              TOKEN(emc_zcal_mrw_cmd) },
	{ "EmcDdr2Wait",                TOKEN(emc_ddr2_wait) },
	{ "PmcDdrPwr",                  TOKEN(pmc_ddr_pwr) },
	{ "EmcClockSource",             TOKEN(emc_clock_source) },
	{ "EmcPinExtraWait",            TOKEN(emc_pin_extra_wait) },
	{ "EmcTimingControlWait",       TOKEN(emc_timing_control_wait) },
	{ "EmcWext",                    TOKEN(emc_wext) },
	{ "EmcCtt",                     TOKEN(emc_ctt) },
	{ "EmcCttDuration",             TOKEN(emc_ctt_duration) },
	{ "EmcPreRefreshReqCnt",        TOKEN(emc_prerefresh_req_cnt) },
	{ "EmcTxsrDll",                 TOKEN(emc_txsr_dll) },
	{ "EmcCfgRsv",                  TOKEN(emc_cfg_rsv) },
	{ "EmcMrwExtra",                TOKEN(emc_mrw_extra) },
	{ "EmcWarmBootMrwExtra",        TOKEN(emc_warm_boot_mrw_extra) },
	{ "EmcWarmBootExtraModeRegWriteEnable",
			TOKEN(emc_warm_boot_extramode_reg_write_enable) },
	{ "EmcExtraModeRegWriteEnable", TOKEN(emc_extramode_reg_write_enable) },
	{ "EmcMrsWaitCnt",              TOKEN(emc_mrs_wait_cnt) },
	{ "EmcMrsWaitCnt2",             TOKEN(emc_mrs_wait_cnt2) },
	{ "EmcCmdQ",                    TOKEN(emc_cmd_q) },
	{ "EmcMc2EmcQ",                 TOKEN(emc_mc2emc_q) },
	{ "EmcDynSelfRefControl",       TOKEN(emc_dyn_self_ref_control) },
	{ "AhbArbitrationXbarCtrlMemInitDone",
			TOKEN(ahb_arbitration_xbar_ctrl_meminit_done) },
	{ "EmcDevSelect",               TOKEN(emc_dev_select) },
	{ "EmcSelDpdCtrl",              TOKEN(emc_sel_dpd_ctrl) },
	{ "EmcDllXformDqs0",            TOKEN(emc_dll_xform_dqs0) },
	{ "EmcDllXformDqs1",            TOKEN(emc_dll_xform_dqs1) },
	{ "EmcDllXformDqs2",            TOKEN(emc_dll_xform_dqs2) },
	{ "EmcDllXformDqs3",            TOKEN(emc_dll_xform_dqs3) },
	{ "EmcDllXformDqs4",            TOKEN(emc_dll_xform_dqs4) },
	{ "EmcDllXformDqs5",            TOKEN(emc_dll_xform_dqs5) },
	{ "EmcDllXformDqs6",            TOKEN(emc_dll_xform_dqs6) },
	{ "EmcDllXformDqs7",            TOKEN(emc_dll_xform_dqs7) },
	{ "EmcDllXformDqs8",            TOKEN(emc_dll_xform_dqs8) },
	{ "EmcDllXformDqs9",            TOKEN(emc_dll_xform_dqs9) },
	{ "EmcDllXformDqs10",           TOKEN(emc_dll_xform_dqs10) },
	{ "EmcDllXformDqs11",           TOKEN(emc_dll_xform_dqs11) },
	{ "EmcDllXformDqs12",           TOKEN(emc_dll_xform_dqs12) },
	{ "EmcDllXformDqs13",           TOKEN(emc_dll_xform_dqs13) },
	{ "EmcDllXformDqs14",           TOKEN(emc_dll_xform_dqs14) },
	{ "EmcDllXformDqs15",           TOKEN(emc_dll_xform_dqs15) },
	{ "EmcDllXformQUse0",           TOKEN(emc_dll_xform_quse0) },
	{ "EmcDllXformQUse1",           TOKEN(emc_dll_xform_quse1) },
	{ "EmcDllXformQUse2",           TOKEN(emc_dll_xform_quse2) },
	{ "EmcDllXformQUse3",           TOKEN(emc_dll_xform_quse3) },
	{ "EmcDllXformQUse4",           TOKEN(emc_dll_xform_quse4) },
	{ "EmcDllXformQUse5",           TOKEN(emc_dll_xform_quse5) },
	{ "EmcDllXformQUse6",           TOKEN(emc_dll_xform_quse6) },
	{ "EmcDllXformQUse7",           TOKEN(emc_dll_xform_quse7) },
	{ "EmcDllXformAddr0",           TOKEN(emc_dll_xform_addr0) },
	{ "EmcDllXformAddr1",           TOKEN(emc_dll_xform_addr1) },
	{ "EmcDllXformAddr2",           TOKEN(emc_dll_xform_addr2) },
	{ "EmcDllXformAddr3",           TOKEN(emc_dll_xform_addr3) },
	{ "EmcDllXformAddr4",           TOKEN(emc_dll_xform_addr4) },
	{ "EmcDllXformAddr5",           TOKEN(emc_dll_xform_addr5) },
	{ "EmcDllXformQUse8",           TOKEN(emc_dll_xform_quse8) },
	{ "EmcDllXformQUse9",           TOKEN(emc_dll_xform_quse9) },
	{ "EmcDllXformQUse10",          TOKEN(emc_dll_xform_quse10) },
	{ "EmcDllXformQUse11",          TOKEN(emc_dll_xform_quse11) },
	{ "EmcDllXformQUse12",          TOKEN(emc_dll_xform_quse12) },
	{ "EmcDllXformQUse13",          TOKEN(emc_dll_xform_quse13) },
	{ "EmcDllXformQUse14",          TOKEN(emc_dll_xform_quse14) },
	{ "EmcDllXformQUse15",          TOKEN(emc_dll_xform_quse15) },
	{ "EmcDliTrimTxDqs0",           TOKEN(emc_dli_trim_tx_dqs0) },
	{ "EmcDliTrimTxDqs1",           TOKEN(emc_dli_trim_tx_dqs1) },
	{ "EmcDliTrimTxDqs2",           TOKEN(emc_dli_trim_tx_dqs2) },
	{ "EmcDliTrimTxDqs3",           TOKEN(emc_dli_trim_tx_dqs3) },
	{ "EmcDliTrimTxDqs4",           TOKEN(emc_dli_trim_tx_dqs4) },
	{ "EmcDliTrimTxDqs5",           TOKEN(emc_dli_trim_tx_dqs5) },
	{ "EmcDliTrimTxDqs6",           TOKEN(emc_dli_trim_tx_dqs6) },
	{ "EmcDliTrimTxDqs7",           TOKEN(emc_dli_trim_tx_dqs7) },
	{ "EmcDliTrimTxDqs8",           TOKEN(emc_dli_trim_tx_dqs8) },
	{ "EmcDliTrimTxDqs9",           TOKEN(emc_dli_trim_tx_dqs9) },
	{ "EmcDliTrimTxDqs10",          TOKEN(emc_dli_trim_tx_dqs10) },
	{ "EmcDliTrimTxDqs11",          TOKEN(emc_dli_trim_tx_dqs11) },
	{ "EmcDliTrimTxDqs12",          TOKEN(emc_dli_trim_tx_dqs12) },
	{ "EmcDliTrimTxDqs13",          TOKEN(emc_dli_trim_tx_dqs13) },
	{ "EmcDliTrimTxDqs14",          TOKEN(emc_dli_trim_tx_dqs14) },
	{ "EmcDliTrimTxDqs15",          TOKEN(emc_dli_trim_tx_dqs15) },
	{ "EmcDllXformDq0",             TOKEN(emc_dll_xform_dq0) },
	{ "EmcDllXformDq1",             TOKEN(emc_dll_xform_dq1) },
	{ "EmcDllXformDq2",             TOKEN(emc_dll_xform_dq2) },
	{ "EmcDllXformDq3",             TOKEN(emc_dll_xform_dq3) },
	{ "EmcDllXformDq4",             TOKEN(emc_dll_xform_dq4) },
	{ "EmcDllXformDq5",             TOKEN(emc_dll_xform_dq5) },
	{ "EmcDllXformDq6",             TOKEN(emc_dll_xform_dq6) },
	{ "EmcDllXformDq7",             TOKEN(emc_dll_xform_dq7) },
	{ "EmcZcalInterval",            TOKEN(emc_zcal_interval) },
	{ "EmcZcalInitDev0",            TOKEN(emc_zcal_init_dev0) },
	{ "EmcZcalInitDev1",            TOKEN(emc_zcal_init_dev1) },
	{ "EmcZcalInitWait",            TOKEN(emc_zcal_init_wait) },
	{ "EmcZcalWarmColdBootEnables", TOKEN(emc_zcal_warm_cold_boot_enables) },
	{ "EmcMrwLpddr2ZcalWarmBoot",   TOKEN(emc_mrw_lpddr2zcal_warm_boot) },
	{ "EmcZqCalDdr3WarmBoot",       TOKEN(emc_zqcal_ddr3_warm_boot) },
	{ "EmcZcalWarmBootWait",        TOKEN(emc_zcal_warm_boot_wait) },
	{ "EmcMrsWarmBootEnable",       TOKEN(emc_mrs_warm_boot_enable) },
	{ "EmcMrsExtra",                TOKEN(emc_mrs_extra) },
	{ "EmcWarmBootMrsExtra",        TOKEN(emc_warm_boot_mrs_extra) },
	{ "EmcClkenOverride",           TOKEN(emc_clken_override) },
	{ "McDisExtraSnapLevels",       TOKEN(mc_dis_extra_snap_levels) },
	{ "EmcExtraRefreshNum",         TOKEN(emc_extra_refresh_num) },
	{ "EmcClkenOverrideAllWarmBoot",
			TOKEN(emc_clken_override_allwarm_boot) },
	{ "McClkenOverrideAllWarmBoot", TOKEN(mc_clken_override_allwarm_boot) },
	{ "EmcCfgDigDllPeriodWarmBoot",
			TOKEN(emc_cfg_dig_dll_period_warm_boot) },
	{ "PmcVddpSel",                 TOKEN(pmc_vddp_sel) },
	{ "PmcVddpSelWait",             TOKEN(pmc_vddp_sel_wait) },
	{ "PmcDdrCfg",                  TOKEN(pmc_ddr_cfg) },
	{ "PmcIoDpd3Req",               TOKEN(pmc_io_dpd3_req) },
	{ "PmcIoDpd3ReqWait",           TOKEN(pmc_io_dpd3_req_wait) },
	{ "PmcRegShort",                TOKEN(pmc_reg_short) },
	{ "PmcNoIoPower",               TOKEN(pmc_no_io_power) },
	{ "PmcPorDpdCtrlWait",          TOKEN(pmc_por_dpd_ctrl_wait) },
	{ "EmcXm2CmdPadCtrl",           TOKEN(emc_xm2cmd_pad_ctrl) },
	{ "EmcXm2CmdPadCtrl2",          TOKEN(emc_xm2cmd_pad_ctrl2) },
	{ "EmcXm2CmdPadCtrl3",          TOKEN(emc_xm2cmd_pad_ctrl3) },
	{ "EmcXm2CmdPadCtrl4",          TOKEN(emc_xm2cmd_pad_ctrl4) },
	{ "EmcXm2CmdPadCtrl5",          TOKEN(emc_xm2cmd_pad_ctrl5) },
	{ "EmcXm2DqsPadCtrl",           TOKEN(emc_xm2dqs_pad_ctrl) },
	{ "EmcXm2DqsPadCtrl2",          TOKEN(emc_xm2dqs_pad_ctrl2) },
	{ "EmcXm2DqsPadCtrl3",          TOKEN(emc_xm2dqs_pad_ctrl3) },
	{ "EmcXm2DqsPadCtrl4",          TOKEN(emc_xm2dqs_pad_ctrl4) },
	{ "EmcXm2DqsPadCtrl5",          TOKEN(emc_xm2dqs_pad_ctrl5) },
	{ "EmcXm2DqsPadCtrl6",          TOKEN(emc_xm2dqs_pad_ctrl6) },
	{ "EmcXm2DqPadCtrl",            TOKEN(emc_xm2dq_pad_ctrl) },
	{ "EmcXm2DqPadCtrl2",           TOKEN(emc_xm2dq_pad_ctrl2) },
	{ "EmcXm2DqPadCtrl3",           TOKEN(emc_xm2dq_pad_ctrl3) },
	{ "EmcXm2ClkPadCtrl",           TOKEN(emc_xm2clk_pad_ctrl) },
	{ "EmcXm2ClkPadCtrl2",          TOKEN(emc_xm2clk_pad_ctrl2) },
	{ "EmcXm2CompPadCtrl",          TOKEN(emc_xm2comp_pad_ctrl) },
	{ "EmcXm2VttGenPadCtrl",        TOKEN(emc_xm2vttgen_pad_ctrl) },
	{ "EmcXm2VttGenPadCtrl2",       TOKEN(emc_xm2vttgen_pad_ctrl2) },
	{ "EmcXm2VttGenPadCtrl3",       TOKEN(emc_xm2vttgen_pad_ctrl3) },
	{ "EmcAcpdControl",             TOKEN(emc_acpd_control) },
	{ "EmcSwizzleRank0ByteCfg",     TOKEN(emc_swizzle_rank0_byte_cfg) },
	{ "EmcSwizzleRank0Byte0",       TOKEN(emc_swizzle_rank0_byte0) },
	{ "EmcSwizzleRank0Byte1",       TOKEN(emc_swizzle_rank0_byte1) },
	{ "EmcSwizzleRank0Byte2",       TOKEN(emc_swizzle_rank0_byte2) },
	{ "EmcSwizzleRank0Byte3",       TOKEN(emc_swizzle_rank0_byte3) },
	{ "EmcSwizzleRank1ByteCfg",     TOKEN(emc_swizzle_rank1_byte_cfg) },
	{ "EmcSwizzleRank1Byte0",       TOKEN(emc_swizzle_rank1_byte0) },
	{ "EmcSwizzleRank1Byte1",       TOKEN(emc_swizzle_rank1_byte1) },
	{ "EmcSwizzleRank1Byte2",       TOKEN(emc_swizzle_rank1_byte2) },
	{ "EmcSwizzleRank1Byte3",       TOKEN(emc_swizzle_rank1_byte3) },
	{ "EmcDsrVttgenDrv",            TOKEN(emc_dsr_vttgen_drv) },
	{ "EmcTxdsrvttgen",             TOKEN(emc_txdsrvttgen) },
	{ "EmcBgbiasCtl0",              TOKEN(emc_bgbias_ctl0) },
	{ "McEmemAdrCfg",               TOKEN(mc_emem_adr_cfg) },
	{ "McEmemAdrCfgDev0",           TOKEN(mc_emem_adr_cfg_dev0) },
	{ "McEmemAdrCfgDev1",           TOKEN(mc_emem_adr_cfg_dev1) },
	{ "McEmemAdrCfgBankMask0",      TOKEN(mc_emem_adr_cfg_bank_mask0) },
	{ "McEmemAdrCfgBankMask1",      TOKEN(mc_emem_adr_cfg_bank_mask1) },
	{ "McEmemAdrCfgBankMask2",      TOKEN(mc_emem_adr_cfg_bank_mask2) },
	{ "McEmemAdrCfgBankSwizzle3",   TOKEN(mc_emem_adr_cfg_bank_swizzle3) },
	{ "McEmemArbCfg",               TOKEN(mc_emem_arb_cfg) },
	{ "McEmemArbOutstandingReq",    TOKEN(mc_emem_arb_outstanding_req) },
	{ "McEmemArbTimingRcd",         TOKEN(mc_emem_arb_timing_rcd) },
	{ "McEmemArbTimingRp",          TOKEN(mc_emem_arb_timing_rp) },
	{ "McEmemArbTimingRc",          TOKEN(mc_emem_arb_timing_rc) },
	{ "McEmemArbTimingRas",         TOKEN(mc_emem_arb_timing_ras) },
	{ "McEmemArbTimingFaw",         TOKEN(mc_emem_arb_timing_faw) },
	{ "McEmemArbTimingRrd",         TOKEN(mc_emem_arb_timing_rrd) },
	{ "McEmemArbTimingRap2Pre",     TOKEN(mc_emem_arb_timing_rap2pre) },
	{ "McEmemArbTimingWap2Pre",     TOKEN(mc_emem_arb_timing_wap2pre) },
	{ "McEmemArbTimingR2R",         TOKEN(mc_emem_arb_timing_r2r) },
	{ "McEmemArbTimingW2W",         TOKEN(mc_emem_arb_timing_w2w) },
	{ "McEmemArbTimingR2W",         TOKEN(mc_emem_arb_timing_r2w) },
	{ "McEmemArbTimingW2R",         TOKEN(mc_emem_arb_timing_w2r) },
	{ "McEmemArbDaTurns",           TOKEN(mc_emem_arb_da_turns) },
	{ "McEmemArbDaCovers",          TOKEN(mc_emem_arb_da_covers) },
	{ "McEmemArbMisc0",             TOKEN(mc_emem_arb_misc0) },
	{ "McEmemArbMisc1",             TOKEN(mc_emem_arb_misc1) },
	{ "McEmemArbRing1Throttle",     TOKEN(mc_emem_arb_ring1_throttle) },
	{ "McEmemArbOverride",          TOKEN(mc_emem_arb_override) },
	{ "McEmemArbOverride1",         TOKEN(mc_emem_arb_override1) },
	{ "McEmemArbRsv",               TOKEN(mc_emem_arb_rsv) },
	{ "McClkenOverride",            TOKEN(mc_clken_override) },
	{ "McStatControl",              TOKEN(mc_stat_control) },
	{ "McDisplaySnapRing",          TOKEN(mc_display_snap_ring) },
	{ "McVideoProtectBom",          TOKEN(mc_video_protect_bom) },
	{ "McVideoProtectBomAdrHi",
			TOKEN(mc_video_protect_bom_adr_hi) },
	{ "McVideoProtectSizeMb",       TOKEN(mc_video_protect_size_mb) },
	{ "McVideoProtectVprOverride",  TOKEN(mc_video_protect_vpr_override) },
	{ "McVideoProtectVprOverride1", TOKEN(mc_video_protect_vpr_override1) },
	{ "McVideoProtectGpuOverride0", TOKEN(mc_video_protect_gpu_override0) },
	{ "McVideoProtectGpuOverride1", TOKEN(mc_video_protect_gpu_override1) },
	{ "McSecCarveoutBom",           TOKEN(mc_sec_carveout_bom) },
	{ "McSecCarveoutAdrHi",         TOKEN(mc_sec_carveout_adr_hi) },
	{ "McSecCarveoutSizeMb",        TOKEN(mc_sec_carveout_size_mb) },
	{ "McVideoProtectWriteAccess",  TOKEN(mc_video_protect_write_access) },
	{ "McSecCarveoutProtectWriteAccess",
			TOKEN(mc_sec_carveout_protect_write_access) },
	{ "EmcCaTrainingEnable",        TOKEN(emc_ca_training_enable) },
	{ "EmcCaTrainingTimingCntl1",   TOKEN(emc_ca_training_timing_cntl1) },
	{ "EmcCaTrainingTimingCntl2",   TOKEN(emc_ca_training_timing_cntl2) },
	{ "SwizzleRankByteEncode",      TOKEN(swizzle_rank_byte_encode) },
	{ "BootRomPatchControl",        TOKEN(boot_rom_patch_control) },
	{ "BootRomPatchData",           TOKEN(boot_rom_patch_data) },
	{ "McMtsCarveoutBom",           TOKEN(mc_mts_carveout_bom) },
	{ "McMtsCarveoutAdrHi",         TOKEN(mc_mts_carveout_adr_hi) },
	{ "McMtsCarveoutSizeMb",        TOKEN(mc_mts_carveout_size_mb) },
	{ "McMtsCarveoutRegCtrl",       TOKEN(mc_mts_carveout_reg_ctrl) },
	{ NULL, 0, 0, NULL }
};

field_item s_sdmmc_table_t124[] = {
	{ "ClockDivider",               TOKEN(sdmmc_clock_divider) },
	{ "DataWidth",
	  token_sdmmc_data_width,
	  field_type_enum,
	  s_sdmmc_data_width_table_t124 },
	{ "MaxPowerClassSupported",     TOKEN(sdmmc_max_power_class_supported) },
	{ "MultiPageSupport",           TOKEN(sdmmc_multi_page_support) },
	{ NULL, 0, 0, NULL }
};

field_item s_spiflash_table_t124[] = {
	{ "ReadCommandTypeFast",        TOKEN(spiflash_read_command_type_fast) },
	{ "PageSize2kor16k",            TOKEN(spiflash_page_size_2k_or_16k) },
	{ "ClockDivider",               TOKEN(spiflash_clock_divider) },
	{ "ClockSource",
	  token_spiflash_clock_source,
	  field_type_enum,
	  s_spi_clock_source_table_t124 },
	{ NULL, 0, 0, NULL }
};

parse_subfield_item s_device_type_table_t124[] = {
	{ "SdmmcParams.", token_sdmmc_params,
		s_sdmmc_table_t124, t124_set_dev_param },
	{ "SpiFlashParams.", token_spiflash_params,
		s_spiflash_table_t124, t124_set_dev_param },
	{ NULL, 0, NULL }
};
