/*
 *  Copyright (C) 2017 Pengutronix, Steffen Trumtrar <kernel@pengutronix.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef _ARRIA10_PINMUX_H_
#define _ARRIA10_PINMUX_H_

#include <mach/arria10-regs.h>

#define ARRIA10_PINMUX_SHARED_IO_Q1_1_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x00
#define ARRIA10_PINMUX_SHARED_IO_Q1_2_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x04
#define ARRIA10_PINMUX_SHARED_IO_Q1_3_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x08
#define ARRIA10_PINMUX_SHARED_IO_Q1_4_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x0c
#define ARRIA10_PINMUX_SHARED_IO_Q1_5_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x10
#define ARRIA10_PINMUX_SHARED_IO_Q1_6_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x14
#define ARRIA10_PINMUX_SHARED_IO_Q1_7_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x18
#define ARRIA10_PINMUX_SHARED_IO_Q1_8_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x1c
#define ARRIA10_PINMUX_SHARED_IO_Q1_9_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x20
#define ARRIA10_PINMUX_SHARED_IO_Q1_10_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x24
#define ARRIA10_PINMUX_SHARED_IO_Q1_11_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x28
#define ARRIA10_PINMUX_SHARED_IO_Q1_12_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x2c
#define ARRIA10_PINMUX_SHARED_IO_Q2_1_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x30
#define ARRIA10_PINMUX_SHARED_IO_Q2_2_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x34
#define ARRIA10_PINMUX_SHARED_IO_Q2_3_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x38
#define ARRIA10_PINMUX_SHARED_IO_Q2_4_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x3c
#define ARRIA10_PINMUX_SHARED_IO_Q2_5_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x40
#define ARRIA10_PINMUX_SHARED_IO_Q2_6_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x44
#define ARRIA10_PINMUX_SHARED_IO_Q2_7_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x48
#define ARRIA10_PINMUX_SHARED_IO_Q2_8_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x4c
#define ARRIA10_PINMUX_SHARED_IO_Q2_9_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x50
#define ARRIA10_PINMUX_SHARED_IO_Q2_10_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x54
#define ARRIA10_PINMUX_SHARED_IO_Q2_11_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x58
#define ARRIA10_PINMUX_SHARED_IO_Q2_12_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x5c
#define ARRIA10_PINMUX_SHARED_IO_Q3_1_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x60
#define ARRIA10_PINMUX_SHARED_IO_Q3_2_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x64
#define ARRIA10_PINMUX_SHARED_IO_Q3_3_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x68
#define ARRIA10_PINMUX_SHARED_IO_Q3_4_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x6c
#define ARRIA10_PINMUX_SHARED_IO_Q3_5_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x70
#define ARRIA10_PINMUX_SHARED_IO_Q3_6_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x74
#define ARRIA10_PINMUX_SHARED_IO_Q3_7_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x78
#define ARRIA10_PINMUX_SHARED_IO_Q3_8_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x7c
#define ARRIA10_PINMUX_SHARED_IO_Q3_9_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x80
#define ARRIA10_PINMUX_SHARED_IO_Q3_10_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x84
#define ARRIA10_PINMUX_SHARED_IO_Q3_11_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x88
#define ARRIA10_PINMUX_SHARED_IO_Q3_12_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x8c
#define ARRIA10_PINMUX_SHARED_IO_Q4_1_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x90
#define ARRIA10_PINMUX_SHARED_IO_Q4_2_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x94
#define ARRIA10_PINMUX_SHARED_IO_Q4_3_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x98
#define ARRIA10_PINMUX_SHARED_IO_Q4_4_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0x9c
#define ARRIA10_PINMUX_SHARED_IO_Q4_5_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0xa0
#define ARRIA10_PINMUX_SHARED_IO_Q4_6_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0xa4
#define ARRIA10_PINMUX_SHARED_IO_Q4_7_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0xa8
#define ARRIA10_PINMUX_SHARED_IO_Q4_8_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0xac
#define ARRIA10_PINMUX_SHARED_IO_Q4_9_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0xb0
#define ARRIA10_PINMUX_SHARED_IO_Q4_10_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0xb4
#define ARRIA10_PINMUX_SHARED_IO_Q4_11_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0xb8
#define ARRIA10_PINMUX_SHARED_IO_Q4_12_ADDR	ARRIA10_PINMUX_SHARED_3V_IO_GRP_ADDR + 0xbc

#define ARRIA10_PINMUX_SHARED_IO_Q1_I2C		0
#define ARRIA10_PINMUX_SHARED_IO_Q1_EMAC	1
#define ARRIA10_PINMUX_SHARED_IO_Q1_SPIS	2
#define ARRIA10_PINMUX_SHARED_IO_Q1_SPIM	3
#define ARRIA10_PINMUX_SHARED_IO_Q1_SDMMC	4
#define ARRIA10_PINMUX_SHARED_IO_Q1_USB		8
#define ARRIA10_PINMUX_SHARED_IO_Q1_QSPI	12
#define ARRIA10_PINMUX_SHARED_IO_Q1_UART	13
#define ARRIA10_PINMUX_SHARED_IO_Q1_NAND	14
#define ARRIA10_PINMUX_SHARED_IO_Q1_GPIO	15

#define ARRIA10_PINMUX_SHARED_IO_Q2_I2C		0
#define ARRIA10_PINMUX_SHARED_IO_Q2_SPIS	2
#define ARRIA10_PINMUX_SHARED_IO_Q2_SPIM	3
#define ARRIA10_PINMUX_SHARED_IO_Q2_EMAC	4
#define ARRIA10_PINMUX_SHARED_IO_Q2_USB		8
#define ARRIA10_PINMUX_SHARED_IO_Q2_UART	13
#define ARRIA10_PINMUX_SHARED_IO_Q2_NAND	14
#define ARRIA10_PINMUX_SHARED_IO_Q2_GPIO	15

#define ARRIA10_PINMUX_SHARED_IO_Q3_I2C		0
#define ARRIA10_PINMUX_SHARED_IO_Q3_EMAC0	1
#define ARRIA10_PINMUX_SHARED_IO_Q3_SPIS	2
#define ARRIA10_PINMUX_SHARED_IO_Q3_SPIM	3
#define ARRIA10_PINMUX_SHARED_IO_Q3_EMAC1	8
#define ARRIA10_PINMUX_SHARED_IO_Q3_UART	13
#define ARRIA10_PINMUX_SHARED_IO_Q3_NAND	14
#define ARRIA10_PINMUX_SHARED_IO_Q3_GPIO	15

#define ARRIA10_PINMUX_SHARED_IO_Q4_I2C		0
#define ARRIA10_PINMUX_SHARED_IO_Q4_EMAC0	1
#define ARRIA10_PINMUX_SHARED_IO_Q4_SPIS	2
#define ARRIA10_PINMUX_SHARED_IO_Q4_SPIM	3
#define ARRIA10_PINMUX_SHARED_IO_Q4_SDMMC	4
#define ARRIA10_PINMUX_SHARED_IO_Q4_EMAC1	8
#define ARRIA10_PINMUX_SHARED_IO_Q4_QSPI	12
#define ARRIA10_PINMUX_SHARED_IO_Q4_UART	13
#define ARRIA10_PINMUX_SHARED_IO_Q4_NAND	14
#define ARRIA10_PINMUX_SHARED_IO_Q4_GPIO	15

#define ARRIA10_PINMUX_DEDICATED_IO_1_ADDR	ARRIA10_PINMUX_DEDICATED_IO_GRP_ADDR + 0x00
#define ARRIA10_PINMUX_DEDICATED_IO_2_ADDR	ARRIA10_PINMUX_DEDICATED_IO_GRP_ADDR + 0x04
#define ARRIA10_PINMUX_DEDICATED_IO_3_ADDR	ARRIA10_PINMUX_DEDICATED_IO_GRP_ADDR + 0x08
#define ARRIA10_PINMUX_DEDICATED_IO_4_ADDR	ARRIA10_PINMUX_DEDICATED_IO_GRP_ADDR + 0x0c
#define ARRIA10_PINMUX_DEDICATED_IO_5_ADDR	ARRIA10_PINMUX_DEDICATED_IO_GRP_ADDR + 0x10
#define ARRIA10_PINMUX_DEDICATED_IO_6_ADDR	ARRIA10_PINMUX_DEDICATED_IO_GRP_ADDR + 0x14
#define ARRIA10_PINMUX_DEDICATED_IO_7_ADDR	ARRIA10_PINMUX_DEDICATED_IO_GRP_ADDR + 0x18
#define ARRIA10_PINMUX_DEDICATED_IO_8_ADDR	ARRIA10_PINMUX_DEDICATED_IO_GRP_ADDR + 0x1c
#define ARRIA10_PINMUX_DEDICATED_IO_9_ADDR	ARRIA10_PINMUX_DEDICATED_IO_GRP_ADDR + 0x20
#define ARRIA10_PINMUX_DEDICATED_IO_10_ADDR	ARRIA10_PINMUX_DEDICATED_IO_GRP_ADDR + 0x24
#define ARRIA10_PINMUX_DEDICATED_IO_11_ADDR	ARRIA10_PINMUX_DEDICATED_IO_GRP_ADDR + 0x28
#define ARRIA10_PINMUX_DEDICATED_IO_12_ADDR	ARRIA10_PINMUX_DEDICATED_IO_GRP_ADDR + 0x2c
#define ARRIA10_PINMUX_DEDICATED_IO_13_ADDR	ARRIA10_PINMUX_DEDICATED_IO_GRP_ADDR + 0x30
#define ARRIA10_PINMUX_DEDICATED_IO_14_ADDR	ARRIA10_PINMUX_DEDICATED_IO_GRP_ADDR + 0x34
#define ARRIA10_PINMUX_DEDICATED_IO_15_ADDR	ARRIA10_PINMUX_DEDICATED_IO_GRP_ADDR + 0x38
#define ARRIA10_PINMUX_DEDICATED_IO_16_ADDR	ARRIA10_PINMUX_DEDICATED_IO_GRP_ADDR + 0x3c
#define ARRIA10_PINMUX_DEDICATED_IO_17_ADDR	ARRIA10_PINMUX_DEDICATED_IO_GRP_ADDR + 0x40

#define ARRIA10_PINCFG_DEDICATED_IO_BANK_ADDR	ARRIA10_PINMUX_CFG_DEDICATED_IO_GRP_ADDR + 0x00
#define ARRIA10_PINCFG_DEDICATED_IO_1_ADDR	ARRIA10_PINMUX_CFG_DEDICATED_IO_GRP_ADDR + 0x04
#define ARRIA10_PINCFG_DEDICATED_IO_2_ADDR	ARRIA10_PINMUX_CFG_DEDICATED_IO_GRP_ADDR + 0x08
#define ARRIA10_PINCFG_DEDICATED_IO_3_ADDR	ARRIA10_PINMUX_CFG_DEDICATED_IO_GRP_ADDR + 0x0c
#define ARRIA10_PINCFG_DEDICATED_IO_4_ADDR	ARRIA10_PINMUX_CFG_DEDICATED_IO_GRP_ADDR + 0x10
#define ARRIA10_PINCFG_DEDICATED_IO_5_ADDR	ARRIA10_PINMUX_CFG_DEDICATED_IO_GRP_ADDR + 0x14
#define ARRIA10_PINCFG_DEDICATED_IO_6_ADDR	ARRIA10_PINMUX_CFG_DEDICATED_IO_GRP_ADDR + 0x18
#define ARRIA10_PINCFG_DEDICATED_IO_7_ADDR	ARRIA10_PINMUX_CFG_DEDICATED_IO_GRP_ADDR + 0x1c
#define ARRIA10_PINCFG_DEDICATED_IO_8_ADDR	ARRIA10_PINMUX_CFG_DEDICATED_IO_GRP_ADDR + 0x20
#define ARRIA10_PINCFG_DEDICATED_IO_9_ADDR	ARRIA10_PINMUX_CFG_DEDICATED_IO_GRP_ADDR + 0x24
#define ARRIA10_PINCFG_DEDICATED_IO_10_ADDR	ARRIA10_PINMUX_CFG_DEDICATED_IO_GRP_ADDR + 0x28
#define ARRIA10_PINCFG_DEDICATED_IO_11_ADDR	ARRIA10_PINMUX_CFG_DEDICATED_IO_GRP_ADDR + 0x2c
#define ARRIA10_PINCFG_DEDICATED_IO_12_ADDR	ARRIA10_PINMUX_CFG_DEDICATED_IO_GRP_ADDR + 0x30
#define ARRIA10_PINCFG_DEDICATED_IO_13_ADDR	ARRIA10_PINMUX_CFG_DEDICATED_IO_GRP_ADDR + 0x34
#define ARRIA10_PINCFG_DEDICATED_IO_14_ADDR	ARRIA10_PINMUX_CFG_DEDICATED_IO_GRP_ADDR + 0x38
#define ARRIA10_PINCFG_DEDICATED_IO_15_ADDR	ARRIA10_PINMUX_CFG_DEDICATED_IO_GRP_ADDR + 0x3c
#define ARRIA10_PINCFG_DEDICATED_IO_16_ADDR	ARRIA10_PINMUX_CFG_DEDICATED_IO_GRP_ADDR + 0x40
#define ARRIA10_PINCFG_DEDICATED_IO_17_ADDR	ARRIA10_PINMUX_CFG_DEDICATED_IO_GRP_ADDR + 0x44

enum arria10_pinmux_io_addr {
	arria10_pinmux_shared_io_q1_1,
	arria10_pinmux_shared_io_q1_2,
	arria10_pinmux_shared_io_q1_3,
	arria10_pinmux_shared_io_q1_4,
	arria10_pinmux_shared_io_q1_5,
	arria10_pinmux_shared_io_q1_6,
	arria10_pinmux_shared_io_q1_7,
	arria10_pinmux_shared_io_q1_8,
	arria10_pinmux_shared_io_q1_9,
	arria10_pinmux_shared_io_q1_10,
	arria10_pinmux_shared_io_q1_11,
	arria10_pinmux_shared_io_q1_12,
	arria10_pinmux_shared_io_q2_1,
	arria10_pinmux_shared_io_q2_2,
	arria10_pinmux_shared_io_q2_3,
	arria10_pinmux_shared_io_q2_4,
	arria10_pinmux_shared_io_q2_5,
	arria10_pinmux_shared_io_q2_6,
	arria10_pinmux_shared_io_q2_7,
	arria10_pinmux_shared_io_q2_8,
	arria10_pinmux_shared_io_q2_9,
	arria10_pinmux_shared_io_q2_10,
	arria10_pinmux_shared_io_q2_11,
	arria10_pinmux_shared_io_q2_12,
	arria10_pinmux_shared_io_q3_1,
	arria10_pinmux_shared_io_q3_2,
	arria10_pinmux_shared_io_q3_3,
	arria10_pinmux_shared_io_q3_4,
	arria10_pinmux_shared_io_q3_5,
	arria10_pinmux_shared_io_q3_6,
	arria10_pinmux_shared_io_q3_7,
	arria10_pinmux_shared_io_q3_8,
	arria10_pinmux_shared_io_q3_9,
	arria10_pinmux_shared_io_q3_10,
	arria10_pinmux_shared_io_q3_11,
	arria10_pinmux_shared_io_q3_12,
	arria10_pinmux_shared_io_q4_1,
	arria10_pinmux_shared_io_q4_2,
	arria10_pinmux_shared_io_q4_3,
	arria10_pinmux_shared_io_q4_4,
	arria10_pinmux_shared_io_q4_5,
	arria10_pinmux_shared_io_q4_6,
	arria10_pinmux_shared_io_q4_7,
	arria10_pinmux_shared_io_q4_8,
	arria10_pinmux_shared_io_q4_9,
	arria10_pinmux_shared_io_q4_10,
	arria10_pinmux_shared_io_q4_11,
	arria10_pinmux_shared_io_q4_12,
	arria10_pinmux_dedicated_io_1,
	arria10_pinmux_dedicated_io_2,
	arria10_pinmux_dedicated_io_3,
	arria10_pinmux_dedicated_io_4,
	arria10_pinmux_dedicated_io_5,
	arria10_pinmux_dedicated_io_6,
	arria10_pinmux_dedicated_io_7,
	arria10_pinmux_dedicated_io_8,
	arria10_pinmux_dedicated_io_9,
	arria10_pinmux_dedicated_io_10,
	arria10_pinmux_dedicated_io_11,
	arria10_pinmux_dedicated_io_12,
	arria10_pinmux_dedicated_io_13,
	arria10_pinmux_dedicated_io_14,
	arria10_pinmux_dedicated_io_15,
	arria10_pinmux_dedicated_io_16,
	arria10_pinmux_dedicated_io_17,
	arria10_pincfg_dedicated_io_bank,
	arria10_pincfg_dedicated_io_1,
	arria10_pincfg_dedicated_io_2,
	arria10_pincfg_dedicated_io_3,
	arria10_pincfg_dedicated_io_4,
	arria10_pincfg_dedicated_io_5,
	arria10_pincfg_dedicated_io_6,
	arria10_pincfg_dedicated_io_7,
	arria10_pincfg_dedicated_io_8,
	arria10_pincfg_dedicated_io_9,
	arria10_pincfg_dedicated_io_10,
	arria10_pincfg_dedicated_io_11,
	arria10_pincfg_dedicated_io_12,
	arria10_pincfg_dedicated_io_13,
	arria10_pincfg_dedicated_io_14,
	arria10_pincfg_dedicated_io_15,
	arria10_pincfg_dedicated_io_16,
	arria10_pincfg_dedicated_io_17,
	arria10_pinmux_rgmii0_usefpga,
	arria10_pinmux_rgmii1_usefpga,
	arria10_pinmux_rgmii2_usefpga,
	arria10_pinmux_i2c0_usefpga,
	arria10_pinmux_i2c1_usefpga,
	arria10_pinmux_i2cemac0_usefpga,
	arria10_pinmux_i2cemac1_usefpga,
	arria10_pinmux_i2cemac2_usefpga,
	arria10_pinmux_nand_usefpga,
	arria10_pinmux_qspi_usefpga,
	arria10_pinmux_sdmmc_usefpga,
	arria10_pinmux_spim0_usefpga,
	arria10_pinmux_spim1_usefpga,
	arria10_pinmux_spis0_usefpga,
	arria10_pinmux_spis1_usefpga,
	arria10_pinmux_uart0_usefpga,
	arria10_pinmux_uart1_usefpga,
	arria10_pinmux_max
};
#endif
