/*
 * Copyright (C) 2010 Michael Grzeschik <mgr@pengutronix.de>
 * Copyright (C) 2010 Sascha Hauer <sha@pengutronix.de>
 *
 * This file is released under the GPLv2
 *
 */

#ifndef __I2C_TWL4030_H
#define __I2C_TWL4030_H

#include <common.h>
#include <i2c/i2c.h>
#include <linux/err.h>

/* LED */
#define TWL4030_LED_LEDEN_LEDAON			(1 << 0)
#define TWL4030_LED_LEDEN_LEDBON			(1 << 1)
#define TWL4030_LED_LEDEN_LEDAPWM			(1 << 4)
#define TWL4030_LED_LEDEN_LEDBPWM			(1 << 5)

/* KEYPAD */
#define TWL4030_KEYPAD_CTRL_KBD_ON			(1 << 6)
#define TWL4030_KEYPAD_CTRL_RP_EN			(1 << 5)
#define TWL4030_KEYPAD_CTRL_TOLE_EN			(1 << 4)
#define TWL4030_KEYPAD_CTRL_TOE_EN			(1 << 3)
#define TWL4030_KEYPAD_CTRL_LK_EN			(1 << 2)
#define TWL4030_KEYPAD_CTRL_SOFTMODEN			(1 << 1)
#define TWL4030_KEYPAD_CTRL_SOFT_NRST			(1 << 0)

/* P[1-3]_SW_EVENTS */
#define TWL4030_PM_MASTER_SW_EVENTS_STOPON_PWRON	(1 << 6)
#define TWL4030_PM_MASTER_SW_EVENTS_STOPON_SYSEN	(1 << 5)
#define TWL4030_PM_MASTER_SW_EVENTS_ENABLE_WARMRESET	(1 << 4)
#define TWL4030_PM_MASTER_SW_EVENTS_LVL_WAKEUP		(1 << 3)
#define TWL4030_PM_MASTER_SW_EVENTS_DEVACT		(1 << 2)
#define TWL4030_PM_MASTER_SW_EVENTS_DEVSLP		(1 << 1)
#define TWL4030_PM_MASTER_SW_EVENTS_DEVOFF		(1 << 0)


enum twl4030_reg {
	/* Register base addresses */
	/* USB */
	TWL4030_BASEADD_USB			= 0x0000,
	/* AUD */
	TWL4030_BASEADD_AUDIO_VOICE		= 0x0100,
	TWL4030_BASEADD_GPIO			= 0x0198,
	TWL4030_BASEADD_INTBR			= 0x0185,
	TWL4030_BASEADD_PIH			= 0x0180,
	TWL4030_BASEADD_TEST			= 0x014C,
	/* AUX */
	TWL4030_BASEADD_INTERRUPTS		= 0x02B9,
	TWL4030_BASEADD_LED			= 0x02EE,
	TWL4030_BASEADD_MADC			= 0x0200,
	TWL4030_BASEADD_MAIN_CHARGE		= 0x0274,
	TWL4030_BASEADD_PRECHARGE		= 0x02AA,
	TWL4030_BASEADD_PWM0			= 0x02F8,
	TWL4030_BASEADD_PWM1			= 0x02FB,
	TWL4030_BASEADD_PWMA			= 0x02EF,
	TWL4030_BASEADD_PWMB			= 0x02F1,
	TWL4030_BASEADD_KEYPAD			= 0x02D2,
	/* POWER */
	TWL4030_BASEADD_BACKUP			= 0x0314,
	TWL4030_BASEADD_INT			= 0x032E,
	TWL4030_BASEADD_PM_MASTER		= 0x0336,
	TWL4030_BASEADD_PM_RECIEVER		= 0x035B,
	TWL4030_BASEADD_RTC			= 0x031C,
	TWL4030_BASEADD_SECURED_REG		= 0x0300,

	/* LED */
	TWL4030_LED_LEDEN			= 0x02EE,

	/*
	 * Voltage Selection in PM Receiver Module
	 */
	TWL4030_PM_RECEIVER_VAUX2_VSEL_18	= 0x05,
	TWL4030_PM_RECEIVER_VAUX3_VSEL_28	= 0x03,
	TWL4030_PM_RECEIVER_VPLL2_VSEL_18	= 0x05,
	TWL4030_PM_RECEIVER_VDAC_VSEL_18 	= 0x03,
	TWL4030_PM_RECEIVER_VMMC1_VSEL_30	= 0x02,

	/*
	 * Device Selection in PM Receiver Module
	 */
	TWL4030_PM_RECEIVER_DEV_GRP_P1		= 0x20,
	TWL4030_PM_RECEIVER_DEV_GRP_ALL		= 0xE0,

	/*
	* Power Management Master
	*/
	TWL4030_PM_MASTER_CFG_P1_TRANSITION	= 0x0336,
	TWL4030_PM_MASTER_CFG_P2_TRANSITION	= 0x0337,
	TWL4030_PM_MASTER_CFG_P3_TRANSITION	= 0x0338,
	TWL4030_PM_MASTER_CFG_P123_TRANSITION	= 0x0339,
	TWL4030_PM_MASTER_STS_BOOT		= 0x033A,
	TWL4030_PM_MASTER_CFG_BOOT		= 0x033B,
	TWL4030_PM_MASTER_SHUNDAN		= 0x033C,
	TWL4030_PM_MASTER_BOOT_BCI		= 0x033D,
	TWL4030_PM_MASTER_CFG_PWRANA1		= 0x033E,
	TWL4030_PM_MASTER_CFG_PWRANA2		= 0x033F,
	TWL4030_PM_MASTER_BGAP_TRIM		= 0x0340,
	TWL4030_PM_MASTER_BACKUP_MISC_STS	= 0x0341,
	TWL4030_PM_MASTER_BACKUP_MISC_CFG	= 0x0342,
	TWL4030_PM_MASTER_BACKUP_MISC_TST	= 0x0343,
	TWL4030_PM_MASTER_PROTECT_KEY		= 0x0344,
	TWL4030_PM_MASTER_STS_HW_CONDITIONS	= 0x0345,
	TWL4030_PM_MASTER_P1_SW_EVENTS		= 0x0346,
	TWL4030_PM_MASTER_P2_SW_EVENTS		= 0x0347,
	TWL4030_PM_MASTER_P3_SW_EVENTS		= 0x0348,
	TWL4030_PM_MASTER_STS_P123_STATE	= 0x0349,
	TWL4030_PM_MASTER_PB_CFG		= 0x034A,
	TWL4030_PM_MASTER_PB_WORD_MSB		= 0x034B,
	TWL4030_PM_MASTER_PB_WORD_LSB		= 0x034C,
	TWL4030_PM_MASTER_SEQ_ADD_W2P		= 0x0352,
	TWL4030_PM_MASTER_SEQ_ADD_P2A		= 0x0353,
	TWL4030_PM_MASTER_SEQ_ADD_A2W		= 0x0354,
	TWL4030_PM_MASTER_SEQ_ADD_A2S		= 0x0355,
	TWL4030_PM_MASTER_SEQ_ADD_S2A12		= 0x0356,
	TWL4030_PM_MASTER_SEQ_ADD_S2A3		= 0x0357,
	TWL4030_PM_MASTER_SEQ_ADD_WARM		= 0x0358,
	TWL4030_PM_MASTER_MEMORY_ADDRESS	= 0x0359,
	TWL4030_PM_MASTER_MEMORY_DATA		= 0x035A,
	TWL4030_PM_MASTER_SC_CONFIG		= 0x035B,
	TWL4030_PM_MASTER_SC_DETECT1		= 0x035C,
	TWL4030_PM_MASTER_SC_DETECT2		= 0x035D,
	TWL4030_PM_MASTER_WATCHDOG_CFG		= 0x035E,
	TWL4030_PM_MASTER_IT_CHECK_CFG		= 0x035F,
	TWL4030_PM_MASTER_VIBRATOR_CFG		= 0x0360,
	TWL4030_PM_MASTER_DCDC_GLOBAL_CFG	= 0x0361,
	TWL4030_PM_MASTER_VDD1_TRIM1		= 0x0362,
	TWL4030_PM_MASTER_VDD1_TRIM2		= 0x0363,
	TWL4030_PM_MASTER_VDD2_TRIM1		= 0x0364,
	TWL4030_PM_MASTER_VDD2_TRIM2		= 0x0365,
	TWL4030_PM_MASTER_VIO_TRIM1		= 0x0366,
	TWL4030_PM_MASTER_VIO_TRIM2		= 0x0367,
	TWL4030_PM_MASTER_MISC_CFG		= 0x0368,
	TWL4030_PM_MASTER_LS_TST_A		= 0x0369,
	TWL4030_PM_MASTER_LS_TST_B		= 0x036A,
	TWL4030_PM_MASTER_LS_TST_C		= 0x036B,
	TWL4030_PM_MASTER_LS_TST_D		= 0x036C,
	TWL4030_PM_MASTER_BB_CFG		= 0x036D,
	TWL4030_PM_MASTER_MISC_TST		= 0x036E,
	TWL4030_PM_MASTER_TRIM1			= 0x036F,

	/* Power Managment Receiver */
	TWL4030_PM_RECEIVER_SC_CONFIG		= 0x035B,
	TWL4030_PM_RECEIVER_SC_DETECT1		= 0x035C,
	TWL4030_PM_RECEIVER_SC_DETECT2		= 0x035D,
	TWL4030_PM_RECEIVER_WATCHDOG_CFG	= 0x035E,
	TWL4030_PM_RECEIVER_IT_CHECK_CFG	= 0x035F,
	TWL4030_PM_RECEIVER_VIBRATOR_CFG	= 0x035F,
	TWL4030_PM_RECEIVER_DC_TO_DC_CFG	= 0x0361,
	TWL4030_PM_RECEIVER_VDD1_TRIM1		= 0x0362,
	TWL4030_PM_RECEIVER_VDD1_TRIM2		= 0x0363,
	TWL4030_PM_RECEIVER_VDD2_TRIM1		= 0x0364,
	TWL4030_PM_RECEIVER_VDD2_TRIM2		= 0x0365,
	TWL4030_PM_RECEIVER_VIO_TRIM1		= 0x0366,
	TWL4030_PM_RECEIVER_VIO_TRIM2		= 0x0367,
	TWL4030_PM_RECEIVER_MISC_CFG		= 0x0368,
	TWL4030_PM_RECEIVER_LS_TST_A		= 0x0369,
	TWL4030_PM_RECEIVER_LS_TST_B		= 0x036A,
	TWL4030_PM_RECEIVER_LS_TST_C		= 0x036B,
	TWL4030_PM_RECEIVER_LS_TST_D		= 0x036C,
	TWL4030_PM_RECEIVER_BB_CFG		= 0x036D,
	TWL4030_PM_RECEIVER_MISC_TST		= 0x036E,
	TWL4030_PM_RECEIVER_TRIM1		= 0x036F,
	TWL4030_PM_RECEIVER_TRIM2		= 0x0370,
	TWL4030_PM_RECEIVER_DC_DC_TIMEOUT	= 0x0371,
	TWL4030_PM_RECEIVER_VAUX1_DEV_GRP	= 0x0372,
	TWL4030_PM_RECEIVER_VAUX1_TYPE		= 0x0373,
	TWL4030_PM_RECEIVER_VAUX1_REMAP		= 0x0374,
	TWL4030_PM_RECEIVER_VAUX1_DEDICATED	= 0x0375,
	TWL4030_PM_RECEIVER_VAUX2_DEV_GRP	= 0x0376,
	TWL4030_PM_RECEIVER_VAUX2_TYPE		= 0x0377,
	TWL4030_PM_RECEIVER_VAUX2_REMAP		= 0x0378,
	TWL4030_PM_RECEIVER_VAUX2_DEDICATED	= 0x0379,
	TWL4030_PM_RECEIVER_VAUX3_DEV_GRP	= 0x037A,
	TWL4030_PM_RECEIVER_VAUX3_TYPE		= 0x037B,
	TWL4030_PM_RECEIVER_VAUX3_REMAP		= 0x037C,
	TWL4030_PM_RECEIVER_VAUX3_DEDICATED	= 0x037D,
	TWL4030_PM_RECEIVER_VAUX4_DEV_GRP	= 0x037E,
	TWL4030_PM_RECEIVER_VAUX4_TYPE		= 0x037F,
	TWL4030_PM_RECEIVER_VAUX4_REMAP		= 0x0380,
	TWL4030_PM_RECEIVER_VAUX4_DEDICATED	= 0x0381,
	TWL4030_PM_RECEIVER_VMMC1_DEV_GRP	= 0x0382,
	TWL4030_PM_RECEIVER_VMMC1_TYPE		= 0x0383,
	TWL4030_PM_RECEIVER_VMMC1_REMAP		= 0x0384,
	TWL4030_PM_RECEIVER_VMMC1_DEDICATED	= 0x0385,
	TWL4030_PM_RECEIVER_VMMC2_DEV_GRP	= 0x0386,
	TWL4030_PM_RECEIVER_VMMC2_TYPE		= 0x0387,
	TWL4030_PM_RECEIVER_VMMC2_REMAP		= 0x0388,
	TWL4030_PM_RECEIVER_VMMC2_DEDICATED	= 0x0389,
	TWL4030_PM_RECEIVER_VPLL1_DEV_GRP	= 0x038A,
	TWL4030_PM_RECEIVER_VPLL1_TYPE		= 0x038B,
	TWL4030_PM_RECEIVER_VPLL1_REMAP		= 0x038C,
	TWL4030_PM_RECEIVER_VPLL1_DEDICATED	= 0x038D,
	TWL4030_PM_RECEIVER_VPLL2_DEV_GRP	= 0x038E,
	TWL4030_PM_RECEIVER_VPLL2_TYPE		= 0x038F,
	TWL4030_PM_RECEIVER_VPLL2_REMAP		= 0x0390,
	TWL4030_PM_RECEIVER_VPLL2_DEDICATED	= 0x0391,
	TWL4030_PM_RECEIVER_VSIM_DEV_GRP	= 0x0392,
	TWL4030_PM_RECEIVER_VSIM_TYPE		= 0x0393,
	TWL4030_PM_RECEIVER_VSIM_REMAP		= 0x0394,
	TWL4030_PM_RECEIVER_VSIM_DEDICATED	= 0x0395,
	TWL4030_PM_RECEIVER_VDAC_DEV_GRP	= 0x0396,
	TWL4030_PM_RECEIVER_VDAC_TYPE		= 0x0397,
	TWL4030_PM_RECEIVER_VDAC_REMAP		= 0x0398,
	TWL4030_PM_RECEIVER_VDAC_DEDICATED	= 0x0399,
	TWL4030_PM_RECEIVER_VINTANA1_DEV_GRP	= 0x039A,
	TWL4030_PM_RECEIVER_VINTANA1_TYP	= 0x039B,
	TWL4030_PM_RECEIVER_VINTANA1_REMAP	= 0x039C,
	TWL4030_PM_RECEIVER_VINTANA1_DEDICATED	= 0x039D,
	TWL4030_PM_RECEIVER_VINTANA2_DEV_GRP	= 0x039E,
	TWL4030_PM_RECEIVER_VINTANA2_TYPE	= 0x039F,
	TWL4030_PM_RECEIVER_VINTANA2_REMAP	= 0x03A0,
	TWL4030_PM_RECEIVER_VINTANA2_DEDICATED	= 0x03A1,
	TWL4030_PM_RECEIVER_VINTDIG_DEV_GRP	= 0x03A2,
	TWL4030_PM_RECEIVER_VINTDIG_TYPE	= 0x03A3,
	TWL4030_PM_RECEIVER_VINTDIG_REMAP	= 0x03A4,
	TWL4030_PM_RECEIVER_VINTDIG_DEDICATED	= 0x03A5,
	TWL4030_PM_RECEIVER_VIO_DEV_GRP		= 0x03A6,
	TWL4030_PM_RECEIVER_VIO_TYPE		= 0x03A7,
	TWL4030_PM_RECEIVER_VIO_REMAP		= 0x03A8,
	TWL4030_PM_RECEIVER_VIO_CFG		= 0x03A9,
	TWL4030_PM_RECEIVER_VIO_MISC_CFG	= 0x03AA,
	TWL4030_PM_RECEIVER_VIO_TEST1		= 0x03AB,
	TWL4030_PM_RECEIVER_VIO_TEST2		= 0x03AC,
	TWL4030_PM_RECEIVER_VIO_OSC		= 0x03AD,
	TWL4030_PM_RECEIVER_VIO_RESERVED	= 0x03AE,
	TWL4030_PM_RECEIVER_VIO_VSEL		= 0x03AF,
	TWL4030_PM_RECEIVER_VDD1_DEV_GRP	= 0x03B0,
	TWL4030_PM_RECEIVER_VDD1_TYPE		= 0x03B1,
	TWL4030_PM_RECEIVER_VDD1_REMAP		= 0x03B2,
	TWL4030_PM_RECEIVER_VDD1_CFG		= 0x03B3,
	TWL4030_PM_RECEIVER_VDD1_MISC_CFG	= 0x03B4,
	TWL4030_PM_RECEIVER_VDD1_TEST1		= 0x03B5,
	TWL4030_PM_RECEIVER_VDD1_TEST2		= 0x03B6,
	TWL4030_PM_RECEIVER_VDD1_OSC		= 0x03B7,
	TWL4030_PM_RECEIVER_VDD1_RESERVED	= 0x03B8,
	TWL4030_PM_RECEIVER_VDD1_VSEL		= 0x03B9,
	TWL4030_PM_RECEIVER_VDD1_VMODE_CFG	= 0x03BA,
	TWL4030_PM_RECEIVER_VDD1_VFLOOR		= 0x03BB,
	TWL4030_PM_RECEIVER_VDD1_VROOF		= 0x03BC,
	TWL4030_PM_RECEIVER_VDD1_STEP		= 0x03BD,
	TWL4030_PM_RECEIVER_VDD2_DEV_GRP	= 0x03BE,
	TWL4030_PM_RECEIVER_VDD2_TYPE		= 0x03BF,
	TWL4030_PM_RECEIVER_VDD2_REMAP		= 0x03C0,
	TWL4030_PM_RECEIVER_VDD2_CFG		= 0x03C1,
	TWL4030_PM_RECEIVER_VDD2_MISC_CFG	= 0x03C2,
	TWL4030_PM_RECEIVER_VDD2_TEST1		= 0x03C3,
	TWL4030_PM_RECEIVER_VDD2_TEST2		= 0x03C4,
	TWL4030_PM_RECEIVER_VDD2_OSC		= 0x03C5,
	TWL4030_PM_RECEIVER_VDD2_RESERVED	= 0x03C6,
	TWL4030_PM_RECEIVER_VDD2_VSEL		= 0x03C7,
	TWL4030_PM_RECEIVER_VDD2_VMODE_CFG	= 0x03C8,
	TWL4030_PM_RECEIVER_VDD2_VFLOOR		= 0x03C9,
	TWL4030_PM_RECEIVER_VDD2_VROOF		= 0x03CA,
	TWL4030_PM_RECEIVER_VDD2_STEP		= 0x03CB,
	TWL4030_PM_RECEIVER_VUSB1V5_DEV_GRP	= 0x03CC,
	TWL4030_PM_RECEIVER_VUSB1V5_TYPE	= 0x03CD,
	TWL4030_PM_RECEIVER_VUSB1V5_REMAP	= 0x03CE,
	TWL4030_PM_RECEIVER_VUSB1V8_DEV_GRP	= 0x03CF,
	TWL4030_PM_RECEIVER_VUSB1V8_TYPE	= 0x03D0,
	TWL4030_PM_RECEIVER_VUSB1V8_REMAP	= 0x03D1,
	TWL4030_PM_RECEIVER_VUSB3V1_DEV_GRP	= 0x03D2,
	TWL4030_PM_RECEIVER_VUSB3V1_TYPE	= 0x03D3,
	TWL4030_PM_RECEIVER_VUSB3V1_REMAP	= 0x03D4,
	TWL4030_PM_RECEIVER_VUSBCP_DEV_GRP	= 0x03D5,
	TWL4030_PM_RECEIVER_VUSBCP_TYPE		= 0x03D6,
	TWL4030_PM_RECEIVER_VUSBCP_REMAP	= 0x03D7,
	TWL4030_PM_RECEIVER_VUSB_DEDICATED1	= 0x03D8,
	TWL4030_PM_RECEIVER_VUSB_DEDICATED2	= 0x03D9,
	TWL4030_PM_RECEIVER_REGEN_DEV_GRP	= 0x03DA,
	TWL4030_PM_RECEIVER_REGEN_TYPE		= 0x03DB,
	TWL4030_PM_RECEIVER_REGEN_REMAP		= 0x03DC,
	TWL4030_PM_RECEIVER_NRESPWRON_DEV_GRP	= 0x03DD,
	TWL4030_PM_RECEIVER_NRESPWRON_TYPE	= 0x03DE,
	TWL4030_PM_RECEIVER_NRESPWRON_REMAP	= 0x03DF,
	TWL4030_PM_RECEIVER_CLKEN_DEV_GRP	= 0x03E0,
	TWL4030_PM_RECEIVER_CLKEN_TYPE		= 0x03E1,
	TWL4030_PM_RECEIVER_CLKEN_REMAP		= 0x03E2,
	TWL4030_PM_RECEIVER_SYSEN_DEV_GRP	= 0x03E3,
	TWL4030_PM_RECEIVER_SYSEN_TYPE		= 0x03E4,
	TWL4030_PM_RECEIVER_SYSEN_REMAP		= 0x03E5,
	TWL4030_PM_RECEIVER_HFCLKOUT_DEV_GRP	= 0x03E6,
	TWL4030_PM_RECEIVER_HFCLKOUT_TYPE	= 0x03E7,
	TWL4030_PM_RECEIVER_HFCLKOUT_REMAP	= 0x03E8,
	TWL4030_PM_RECEIVER_32KCLKOUT_DEV_GRP	= 0x03E9,
	TWL4030_PM_RECEIVER_32KCLKOUT_TYPE	= 0x03EA,
	TWL4030_PM_RECEIVER_32KCLKOUT_REMAP	= 0x03EB,
	TWL4030_PM_RECEIVER_TRITON_RESET_DEV_GR	= 0x03EC,
	TWL4030_PM_RECEIVER_TRITON_RESET_TYPE	= 0x03ED,
	TWL4030_PM_RECEIVER_TRITON_RESET_REMAP	= 0x03EE,
	TWL4030_PM_RECEIVER_MAINREF_DEV_GRP	= 0x03EF,
	TWL4030_PM_RECEIVER_MAINREF_TYPE	= 0x03F0,
	TWL4030_PM_RECEIVER_MAINREF_REMAP	= 0x03F1,

	/* Keypad */
	TWL4030_KEYPAD_KEYP_CTRL_REG		= 0x02D2,
	TWL4030_KEYPAD_KEY_DEB_REG		= 0x02D3,
	TWL4030_KEYPAD_LONG_KEY_REG1		= 0x02D4,
	TWL4030_KEYPAD_LK_PTV_REG		= 0x02D5,
	TWL4030_KEYPAD_TIME_OUT_REG1		= 0x02D6,
	TWL4030_KEYPAD_TIME_OUT_REG2		= 0x02D7,
	TWL4030_KEYPAD_KBC_REG			= 0x02D8,
	TWL4030_KEYPAD_KBR_REG			= 0x02D9,
	TWL4030_KEYPAD_KEYP_SMS			= 0x02DA,
	TWL4030_KEYPAD_FULL_CODE_7_0		= 0x02DB,
	TWL4030_KEYPAD_FULL_CODE_15_8		= 0x02DC,
	TWL4030_KEYPAD_FULL_CODE_23_16		= 0x02DD,
	TWL4030_KEYPAD_FULL_CODE_31_24		= 0x02DE,
	TWL4030_KEYPAD_FULL_CODE_39_32		= 0x02DF,
	TWL4030_KEYPAD_FULL_CODE_47_40		= 0x02E0,
	TWL4030_KEYPAD_FULL_CODE_55_48		= 0x02E1,
	TWL4030_KEYPAD_FULL_CODE_63_56		= 0x02E2,
	TWL4030_KEYPAD_KEYP_ISR1		= 0x02E3,
	TWL4030_KEYPAD_KEYP_IMR1		= 0x02E4,
	TWL4030_KEYPAD_KEYP_ISR2		= 0x02E5,
	TWL4030_KEYPAD_KEYP_IMR2		= 0x02E6,
	TWL4030_KEYPAD_KEYP_SIR			= 0x02E7,
	TWL4030_KEYPAD_KEYP_EDR			= 0x02E8,
	TWL4030_KEYPAD_KEYP_SIH_CTRL		= 0x02E9,

	/* USB */
	TWL4030_USB_VENDOR_ID_LO		= 0x0000,
	TWL4030_USB_VENDOR_ID_HI		= 0x0001,
	TWL4030_USB_PRODUCT_ID_LO		= 0x0002,
	TWL4030_USB_PRODUCT_ID_HI		= 0x0003,
	TWL4030_USB_FUNC_CTRL			= 0x0004,
	TWL4030_USB_FUNC_CTRL_SET		= 0x0005,
	TWL4030_USB_FUNC_CTRL_CLR		= 0x0006,
	TWL4030_USB_IFC_CTRL			= 0x0007,
	TWL4030_USB_IFC_CTRL_SET		= 0x0008,
	TWL4030_USB_IFC_CTRL_CLR		= 0x0009,
	TWL4030_USB_OTG_CTRL			= 0x000A,
	TWL4030_USB_OTG_CTRL_SET		= 0x000B,
	TWL4030_USB_OTG_CTRL_CLR		= 0x000C,
	TWL4030_USB_USB_INT_EN_RISE		= 0x000D,
	TWL4030_USB_USB_INT_EN_RISE_SET		= 0x000E,
	TWL4030_USB_USB_INT_EN_RISE_CLR		= 0x000F,
	TWL4030_USB_USB_INT_EN_FALL		= 0x0010,
	TWL4030_USB_USB_INT_EN_FALL_SET		= 0x0011,
	TWL4030_USB_USB_INT_EN_FALL_CLR		= 0x0012,
	TWL4030_USB_USB_INT_STS			= 0x0013,
	TWL4030_USB_USB_INT_LATCH		= 0x0014,
	TWL4030_USB_DEBUG			= 0x0015,
	TWL4030_USB_SCRATCH_REG			= 0x0016,
	TWL4030_USB_SCRATCH_REG_SET		= 0x0017,
	TWL4030_USB_SCRATCH_REG_CLR		= 0x0018,
	TWL4030_USB_CARKIT_CTRL			= 0x0019,
	TWL4030_USB_CARKIT_CTRL_SET		= 0x001A,
	TWL4030_USB_CARKIT_CTRL_CLR		= 0x001B,
	TWL4030_USB_CARKIT_INT_DELAY		= 0x001C,
	TWL4030_USB_CARKIT_INT_EN		= 0x001D,
	TWL4030_USB_CARKIT_INT_EN_SET		= 0x001E,
	TWL4030_USB_CARKIT_INT_EN_CLR		= 0x001F,
	TWL4030_USB_CARKIT_INT_STS		= 0x0020,
	TWL4030_USB_CARKIT_INT_LATCH		= 0x0021,
	TWL4030_USB_CARKIT_PLS_CTRL		= 0x0022,
	TWL4030_USB_CARKIT_PLS_CTRL_SET		= 0x0023,
	TWL4030_USB_CARKIT_PLS_CTRL_CLR		= 0x0024,
	TWL4030_USB_TRANS_POS_WIDTH		= 0x0025,
	TWL4030_USB_TRANS_NEG_WIDTH		= 0x0026,
	TWL4030_USB_RCV_PLTY_RECOVERY		= 0x0027,
	TWL4030_USB_MCPC_CTRL			= 0x0030,
	TWL4030_USB_MCPC_CTRL_SET		= 0x0031,
	TWL4030_USB_MCPC_CTRL_CLR		= 0x0032,
	TWL4030_USB_MCPC_IO_CTRL		= 0x0033,
	TWL4030_USB_MCPC_IO_CTRL_SET		= 0x0034,
	TWL4030_USB_MCPC_IO_CTRL_CLR		= 0x0035,
	TWL4030_USB_MCPC_CTRL2			= 0x0036,
	TWL4030_USB_MCPC_CTRL2_SET		= 0x0037,
	TWL4030_USB_MCPC_CTRL2_CLR		= 0x0038,
	TWL4030_USB_OTHER_FUNC_CTRL		= 0x0080,
	TWL4030_USB_OTHER_FUNC_CTRL_SET		= 0x0081,
	TWL4030_USB_OTHER_FUNC_CTRL_CLR		= 0x0082,
	TWL4030_USB_OTHER_IFC_CTRL		= 0x0083,
	TWL4030_USB_OTHER_IFC_CTRL_SET		= 0x0084,
	TWL4030_USB_OTHER_IFC_CTRL_CLR		= 0x0085,
	TWL4030_USB_OTHER_INT_EN_RISE_SET	= 0x0087,
	TWL4030_USB_OTHER_INT_EN_RISE_CLR	= 0x0088,
	TWL4030_USB_OTHER_INT_EN_FALL		= 0x0089,
	TWL4030_USB_OTHER_INT_EN_FALL_SET	= 0x008A,
	TWL4030_USB_OTHER_INT_EN_FALL_CLR	= 0x008B,
	TWL4030_USB_OTHER_INT_STS		= 0x008C,
	TWL4030_USB_OTHER_INT_LATCH		= 0x008D,
	TWL4030_USB_ID_STATUS			= 0x0096,
	TWL4030_USB_CARKIT_SM_1_INT_EN		= 0x0097,
	TWL4030_USB_CARKIT_SM_1_INT_EN_SET	= 0x0098,
	TWL4030_USB_CARKIT_SM_1_INT_EN_CLR	= 0x0099,
	TWL4030_USB_CARKIT_SM_1_INT_STS		= 0x009A,
	TWL4030_USB_CARKIT_SM_1_INT_LATCH	= 0x009B,
	TWL4030_USB_CARKIT_SM_2_INT_EN		= 0x009C,
	TWL4030_USB_CARKIT_SM_2_INT_EN_SET	= 0x009D,
	TWL4030_USB_CARKIT_SM_2_INT_EN_CLR	= 0x009E,
	TWL4030_USB_CARKIT_SM_2_INT_STS		= 0x009F,
	TWL4030_USB_CARKIT_SM_2_INT_LATCH	= 0x00A0,
	TWL4030_USB_CARKIT_SM_CTRL		= 0x00A1,
	TWL4030_USB_CARKIT_SM_CTRL_SET		= 0x00A2,
	TWL4030_USB_CARKIT_SM_CTRL_CLR		= 0x00A3,
	TWL4030_USB_CARKIT_SM_CMD		= 0x00A4,
	TWL4030_USB_CARKIT_SM_CMD_SET		= 0x00A5,
	TWL4030_USB_CARKIT_SM_CMD_CLR		= 0x00A6,
	TWL4030_USB_CARKIT_SM_CMD_STS		= 0x00A7,
	TWL4030_USB_CARKIT_SM_STATUS		= 0x00A8,
	TWL4030_USB_CARKIT_SM_ERR_STATUS	= 0x00AA,
	TWL4030_USB_CARKIT_SM_CTRL_STATE	= 0x00AB,
	TWL4030_USB_POWER_CTRL			= 0x00AC,
	TWL4030_USB_POWER_CTRL_SET		= 0x00AD,
	TWL4030_USB_POWER_CTRL_CLR		= 0x00AE,
	TWL4030_USB_OTHER_IFC_CTRL2		= 0x00AF,
	TWL4030_USB_OTHER_IFC_CTRL2_SET		= 0x00B0,
	TWL4030_USB_OTHER_IFC_CTRL2_CLR		= 0x00B1,
	TWL4030_USB_REG_CTRL_EN			= 0x00B2,
	TWL4030_USB_REG_CTRL_EN_SET		= 0x00B3,
	TWL4030_USB_REG_CTRL_EN_CLR		= 0x00B4,
	TWL4030_USB_REG_CTRL_ERROR		= 0x00B5,
	TWL4030_USB_OTHER_FUNC_CTRL2		= 0x00B8,
	TWL4030_USB_OTHER_FUNC_CTRL2_SET	= 0x00B9,
	TWL4030_USB_OTHER_FUNC_CTRL2_CLR	= 0x00BA,
	TWL4030_USB_CARKIT_ANA_CTRL		= 0x00BB,
	TWL4030_USB_CARKIT_ANA_CTRL_SET		= 0x00BC,
	TWL4030_USB_CARKIT_ANA_CTRL_CLR		= 0x00BD,
	TWL4030_USB_VBUS_DEBOUNCE		= 0x00C0,
	TWL4030_USB_ID_DEBOUNCE			= 0x00C1,
	TWL4030_USB_TPH_DP_CON_MIN		= 0x00C2,
	TWL4030_USB_TPH_DP_CON_MAX		= 0x00C3,
	TWL4030_USB_TCR_DP_CON_MIN		= 0x00C4,
	TWL4030_USB_TCR_DP_CON_MAX		= 0x00C5,
	TWL4030_USB_TPH_DP_PD_SHORT		= 0x00C6,
	TWL4030_USB_TPH_CMD_DLY			= 0x00C7,
	TWL4030_USB_TPH_DET_RST			= 0x00C8,
	TWL4030_USB_TPH_AUD_BIAS		= 0x00C9,
	TWL4030_USB_TCR_UART_DET_MIN		= 0x00CA,
	TWL4030_USB_TCR_UART_DET_MAX		= 0x00CB,
	TWL4030_USB_TPH_ID_INT_PW		= 0x00CD,
	TWL4030_USB_TACC_ID_INT_WAIT		= 0x00CE,
	TWL4030_USB_TACC_ID_INT_PW		= 0x00CF,
	TWL4030_USB_TPH_CMD_WAIT		= 0x00D0,
	TWL4030_USB_TPH_ACK_WAIT		= 0x00D1,
	TWL4030_USB_TPH_DP_DISC_DET		= 0x00D2,
	TWL4030_USB_VBAT_TIMER			= 0x00D3,
	TWL4030_USB_CARKIT_4W_DEBUG		= 0x00E0,
	TWL4030_USB_CARKIT_5W_DEBUG		= 0x00E1,
	TWL4030_USB_PHY_PWR_CTRL		= 0x00FD,
	TWL4030_USB_PHY_CLK_CTRL		= 0x00FE,
	TWL4030_USB_PHY_CLK_CTRL_STS		= 0x00FF,
};

struct twl4030 {
	struct cdev		cdev;
	struct i2c_client	*client;
};

extern struct twl4030 *twl4030_get(void);

extern int twl4030_reg_read(struct twl4030 *twl4030, u16 reg, u8 *val);
extern int twl4030_reg_write(struct twl4030 *twl4030, u16 reg, u8 val);
extern int twl4030_set_bits(struct twl4030 *twl4030, enum twl4030_reg reg, u8 mask, u8 val);

#endif /* __I2C_TWL4030_H */
